
import { _decorator, Component, Node, ImageAsset, assetManager, SpriteFrame, Sprite, Texture2D } from 'cc';
const { ccclass, property } = _decorator;

/**
 * Predefined variables
 * Name = Test
 * DateTime = Fri Nov 05 2021 14:35:29 GMT+0800 (中国标准时间)
 * Author = muxiandong
 * FileBasename = test.ts
 * FileBasenameNoExtension = test
 * URL = db://assets/test.ts
 * ManualUrl = https://docs.cocos.com/creator/3.3/manual/zh/
 *
 */
 
@ccclass('Test')
export class Test extends Component {

    start () {
        // let remoteUrl = "http://***/image/favicon.jpeg";
        let remoteUrl = "https://www.cocos.com/wp-content/themes/cocos/image/home/product/creator.png?v=1619330967"
        let self = this;
        assetManager.loadRemote<ImageAsset>(remoteUrl, function (err, imageAsset) {
            if (err) {
                console.log("err, reason:", err);
                return;
            }
            const spriteFrame = new SpriteFrame();
            const texture = new Texture2D();
            texture.image = imageAsset;
            spriteFrame.texture = texture;
        
            self.node.getComponent(Sprite).spriteFrame = spriteFrame;
        });
    }
}
