
import { _decorator, Component, tween, find, Vec3, TweenSystem, Tween, Node, director } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('Typescript')
export class Typescript extends Component {
    // [1]
    // dummy = '';

    // [2]
    // @property
    // serializableDummy = 0;

    start() {
        // [3]
        let sp = find('Canvas/Sprite');
        let btn = find('Canvas/Button');
        let sl = find('Canvas/SpriteSplash');
        let label = find('Canvas/Label');

        tween(btn)
            .by(2, { eulerAngles: new Vec3(0, 0, 90) })
            .by(1, { scale: new Vec3(2, 2, 2) })
            .by(1, { scale: new Vec3(-2, -2, -2) })
            .union()
            .repeat(30)
            .start();
        tween(sp)
            .by(2, { eulerAngles: new Vec3(0, 0, 90) })
            .by(1, { scale: new Vec3(2, 2, 2) })
            .by(1, { scale: new Vec3(-2, -2, -2) })
            .union()
            .repeat(40)
            .start();
        tween(sl)
            .by(2, { eulerAngles: new Vec3(0, 0, 90) })
            .by(1, { scale: new Vec3(2, 2, 2) })
            .by(1, { scale: new Vec3(-2, -2, -2) })
            .union()
            .repeat(10)
            .start();
        tween(label)
            .by(2, { eulerAngles: new Vec3(0, 0, 90) })
            .by(1, { scale: new Vec3(2, 2, 2) })
            .by(1, { scale: new Vec3(-2, -2, -2) })
            .union()
            .repeat(10)
            .start();

        this.scheduleOnce(()=>{
            this.pauseTarget(sp);
        },5)
        this.scheduleOnce(()=>{
            this.resumeTarget(sp);
        },7)
    }

    stopAllByTarget(node:Node){
        Tween.stopAllByTarget(node);
    }

    stopAllByTag(tag:number){
        Tween.stopAllByTag(tag);
    }

    stopAll(){
        Tween.stopAll();
    }

    pauseAll(){
        TweenSystem.instance.ActionManager.pauseAllRunningActions();
        // TweenSystem.instance.ActionManager.pauseTargets(nodearray);

    }

    resumeAll(){
        let sp = find('Canvas/Sprite');
        let btn = find('Canvas/Button');
        let sl = find('Canvas/SpriteSplash');
        let label = find('Canvas/Label');
        let nodeArray = [sp,btn,sl,label];
        TweenSystem.instance.ActionManager.resumeTargets(nodeArray);

    }
    pauseTarget(node:Node|null){
        TweenSystem.instance.ActionManager.pauseTarget(node as Node);
    }

    resumeTarget(node:Node|null){
        TweenSystem.instance.ActionManager.resumeTarget(node as Node);

    }
    // update (deltaTime: number) {
    //     // [4]
    // }
}

/**
 * [1] Class member could be defined like this.
 * [2] Use `property` decorator if your want the member to be serializable.
 * [3] Your initialization goes here.
 * [4] Your update function goes here.
 *
 * Learn more about scripting: https://docs.cocos.com/creator/3.0/manual/en/scripting/
 * Learn more about CCClass: https://docs.cocos.com/creator/3.0/manual/en/scripting/ccclass.html
 * Learn more about life-cycle callbacks: https://docs.cocos.com/creator/3.0/manual/en/scripting/life-cycle-callbacks.html
 */
