/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./pugins/use.js");
/******/ })
/************************************************************************/
/******/ ({

/***/ "../../node_modules/earcut/src/earcut.js":
/*!***************************************************!*\
  !*** /Users/mu/node_modules/earcut/src/earcut.js ***!
  \***************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
eval("\n\nmodule.exports = earcut;\nmodule.exports.default = earcut;\n\nfunction earcut(data, holeIndices, dim) {\n  dim = dim || 2;\n  var hasHoles = holeIndices && holeIndices.length,\n      outerLen = hasHoles ? holeIndices[0] * dim : data.length,\n      outerNode = linkedList(data, 0, outerLen, dim, true),\n      triangles = [];\n  if (!outerNode || outerNode.next === outerNode.prev) return triangles;\n  var minX, minY, maxX, maxY, x, y, invSize;\n  if (hasHoles) outerNode = eliminateHoles(data, holeIndices, outerNode, dim); // if the shape is not too simple, we'll use z-order curve hash later; calculate polygon bbox\n\n  if (data.length > 80 * dim) {\n    minX = maxX = data[0];\n    minY = maxY = data[1];\n\n    for (var i = dim; i < outerLen; i += dim) {\n      x = data[i];\n      y = data[i + 1];\n      if (x < minX) minX = x;\n      if (y < minY) minY = y;\n      if (x > maxX) maxX = x;\n      if (y > maxY) maxY = y;\n    } // minX, minY and invSize are later used to transform coords into integers for z-order calculation\n\n\n    invSize = Math.max(maxX - minX, maxY - minY);\n    invSize = invSize !== 0 ? 32767 / invSize : 0;\n  }\n\n  earcutLinked(outerNode, triangles, dim, minX, minY, invSize, 0);\n  return triangles;\n} // create a circular doubly linked list from polygon points in the specified winding order\n\n\nfunction linkedList(data, start, end, dim, clockwise) {\n  var i, last;\n\n  if (clockwise === signedArea(data, start, end, dim) > 0) {\n    for (i = start; i < end; i += dim) last = insertNode(i, data[i], data[i + 1], last);\n  } else {\n    for (i = end - dim; i >= start; i -= dim) last = insertNode(i, data[i], data[i + 1], last);\n  }\n\n  if (last && equals(last, last.next)) {\n    removeNode(last);\n    last = last.next;\n  }\n\n  return last;\n} // eliminate colinear or duplicate points\n\n\nfunction filterPoints(start, end) {\n  if (!start) return start;\n  if (!end) end = start;\n  var p = start,\n      again;\n\n  do {\n    again = false;\n\n    if (!p.steiner && (equals(p, p.next) || area(p.prev, p, p.next) === 0)) {\n      removeNode(p);\n      p = end = p.prev;\n      if (p === p.next) break;\n      again = true;\n    } else {\n      p = p.next;\n    }\n  } while (again || p !== end);\n\n  return end;\n} // main ear slicing loop which triangulates a polygon (given as a linked list)\n\n\nfunction earcutLinked(ear, triangles, dim, minX, minY, invSize, pass) {\n  if (!ear) return; // interlink polygon nodes in z-order\n\n  if (!pass && invSize) indexCurve(ear, minX, minY, invSize);\n  var stop = ear,\n      prev,\n      next; // iterate through ears, slicing them one by one\n\n  while (ear.prev !== ear.next) {\n    prev = ear.prev;\n    next = ear.next;\n\n    if (invSize ? isEarHashed(ear, minX, minY, invSize) : isEar(ear)) {\n      // cut off the triangle\n      triangles.push(prev.i / dim | 0);\n      triangles.push(ear.i / dim | 0);\n      triangles.push(next.i / dim | 0);\n      removeNode(ear); // skipping the next vertex leads to less sliver triangles\n\n      ear = next.next;\n      stop = next.next;\n      continue;\n    }\n\n    ear = next; // if we looped through the whole remaining polygon and can't find any more ears\n\n    if (ear === stop) {\n      // try filtering points and slicing again\n      if (!pass) {\n        earcutLinked(filterPoints(ear), triangles, dim, minX, minY, invSize, 1); // if this didn't work, try curing all small self-intersections locally\n      } else if (pass === 1) {\n        ear = cureLocalIntersections(filterPoints(ear), triangles, dim);\n        earcutLinked(ear, triangles, dim, minX, minY, invSize, 2); // as a last resort, try splitting the remaining polygon into two\n      } else if (pass === 2) {\n        splitEarcut(ear, triangles, dim, minX, minY, invSize);\n      }\n\n      break;\n    }\n  }\n} // check whether a polygon node forms a valid ear with adjacent nodes\n\n\nfunction isEar(ear) {\n  var a = ear.prev,\n      b = ear,\n      c = ear.next;\n  if (area(a, b, c) >= 0) return false; // reflex, can't be an ear\n  // now make sure we don't have other points inside the potential ear\n\n  var ax = a.x,\n      bx = b.x,\n      cx = c.x,\n      ay = a.y,\n      by = b.y,\n      cy = c.y; // triangle bbox; min & max are calculated like this for speed\n\n  var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx,\n      y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy,\n      x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx,\n      y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy;\n  var p = c.next;\n\n  while (p !== a) {\n    if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.next;\n  }\n\n  return true;\n}\n\nfunction isEarHashed(ear, minX, minY, invSize) {\n  var a = ear.prev,\n      b = ear,\n      c = ear.next;\n  if (area(a, b, c) >= 0) return false; // reflex, can't be an ear\n\n  var ax = a.x,\n      bx = b.x,\n      cx = c.x,\n      ay = a.y,\n      by = b.y,\n      cy = c.y; // triangle bbox; min & max are calculated like this for speed\n\n  var x0 = ax < bx ? ax < cx ? ax : cx : bx < cx ? bx : cx,\n      y0 = ay < by ? ay < cy ? ay : cy : by < cy ? by : cy,\n      x1 = ax > bx ? ax > cx ? ax : cx : bx > cx ? bx : cx,\n      y1 = ay > by ? ay > cy ? ay : cy : by > cy ? by : cy; // z-order range for the current triangle bbox;\n\n  var minZ = zOrder(x0, y0, minX, minY, invSize),\n      maxZ = zOrder(x1, y1, minX, minY, invSize);\n  var p = ear.prevZ,\n      n = ear.nextZ; // look for points inside the triangle in both directions\n\n  while (p && p.z >= minZ && n && n.z <= maxZ) {\n    if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.prevZ;\n    if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;\n    n = n.nextZ;\n  } // look for remaining points in decreasing z-order\n\n\n  while (p && p.z >= minZ) {\n    if (p.x >= x0 && p.x <= x1 && p.y >= y0 && p.y <= y1 && p !== a && p !== c && pointInTriangle(ax, ay, bx, by, cx, cy, p.x, p.y) && area(p.prev, p, p.next) >= 0) return false;\n    p = p.prevZ;\n  } // look for remaining points in increasing z-order\n\n\n  while (n && n.z <= maxZ) {\n    if (n.x >= x0 && n.x <= x1 && n.y >= y0 && n.y <= y1 && n !== a && n !== c && pointInTriangle(ax, ay, bx, by, cx, cy, n.x, n.y) && area(n.prev, n, n.next) >= 0) return false;\n    n = n.nextZ;\n  }\n\n  return true;\n} // go through all polygon nodes and cure small local self-intersections\n\n\nfunction cureLocalIntersections(start, triangles, dim) {\n  var p = start;\n\n  do {\n    var a = p.prev,\n        b = p.next.next;\n\n    if (!equals(a, b) && intersects(a, p, p.next, b) && locallyInside(a, b) && locallyInside(b, a)) {\n      triangles.push(a.i / dim | 0);\n      triangles.push(p.i / dim | 0);\n      triangles.push(b.i / dim | 0); // remove two nodes involved\n\n      removeNode(p);\n      removeNode(p.next);\n      p = start = b;\n    }\n\n    p = p.next;\n  } while (p !== start);\n\n  return filterPoints(p);\n} // try splitting polygon into two and triangulate them independently\n\n\nfunction splitEarcut(start, triangles, dim, minX, minY, invSize) {\n  // look for a valid diagonal that divides the polygon into two\n  var a = start;\n\n  do {\n    var b = a.next.next;\n\n    while (b !== a.prev) {\n      if (a.i !== b.i && isValidDiagonal(a, b)) {\n        // split the polygon in two by the diagonal\n        var c = splitPolygon(a, b); // filter colinear points around the cuts\n\n        a = filterPoints(a, a.next);\n        c = filterPoints(c, c.next); // run earcut on each half\n\n        earcutLinked(a, triangles, dim, minX, minY, invSize, 0);\n        earcutLinked(c, triangles, dim, minX, minY, invSize, 0);\n        return;\n      }\n\n      b = b.next;\n    }\n\n    a = a.next;\n  } while (a !== start);\n} // link every hole into the outer loop, producing a single-ring polygon without holes\n\n\nfunction eliminateHoles(data, holeIndices, outerNode, dim) {\n  var queue = [],\n      i,\n      len,\n      start,\n      end,\n      list;\n\n  for (i = 0, len = holeIndices.length; i < len; i++) {\n    start = holeIndices[i] * dim;\n    end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;\n    list = linkedList(data, start, end, dim, false);\n    if (list === list.next) list.steiner = true;\n    queue.push(getLeftmost(list));\n  }\n\n  queue.sort(compareX); // process holes from left to right\n\n  for (i = 0; i < queue.length; i++) {\n    outerNode = eliminateHole(queue[i], outerNode);\n  }\n\n  return outerNode;\n}\n\nfunction compareX(a, b) {\n  return a.x - b.x;\n} // find a bridge between vertices that connects hole with an outer ring and and link it\n\n\nfunction eliminateHole(hole, outerNode) {\n  var bridge = findHoleBridge(hole, outerNode);\n\n  if (!bridge) {\n    return outerNode;\n  }\n\n  var bridgeReverse = splitPolygon(bridge, hole); // filter collinear points around the cuts\n\n  filterPoints(bridgeReverse, bridgeReverse.next);\n  return filterPoints(bridge, bridge.next);\n} // David Eberly's algorithm for finding a bridge between hole and outer polygon\n\n\nfunction findHoleBridge(hole, outerNode) {\n  var p = outerNode,\n      hx = hole.x,\n      hy = hole.y,\n      qx = -Infinity,\n      m; // find a segment intersected by a ray from the hole's leftmost point to the left;\n  // segment's endpoint with lesser x will be potential connection point\n\n  do {\n    if (hy <= p.y && hy >= p.next.y && p.next.y !== p.y) {\n      var x = p.x + (hy - p.y) * (p.next.x - p.x) / (p.next.y - p.y);\n\n      if (x <= hx && x > qx) {\n        qx = x;\n        m = p.x < p.next.x ? p : p.next;\n        if (x === hx) return m; // hole touches outer segment; pick leftmost endpoint\n      }\n    }\n\n    p = p.next;\n  } while (p !== outerNode);\n\n  if (!m) return null; // look for points inside the triangle of hole point, segment intersection and endpoint;\n  // if there are no points found, we have a valid connection;\n  // otherwise choose the point of the minimum angle with the ray as connection point\n\n  var stop = m,\n      mx = m.x,\n      my = m.y,\n      tanMin = Infinity,\n      tan;\n  p = m;\n\n  do {\n    if (hx >= p.x && p.x >= mx && hx !== p.x && pointInTriangle(hy < my ? hx : qx, hy, mx, my, hy < my ? qx : hx, hy, p.x, p.y)) {\n      tan = Math.abs(hy - p.y) / (hx - p.x); // tangential\n\n      if (locallyInside(p, hole) && (tan < tanMin || tan === tanMin && (p.x > m.x || p.x === m.x && sectorContainsSector(m, p)))) {\n        m = p;\n        tanMin = tan;\n      }\n    }\n\n    p = p.next;\n  } while (p !== stop);\n\n  return m;\n} // whether sector in vertex m contains sector in vertex p in the same coordinates\n\n\nfunction sectorContainsSector(m, p) {\n  return area(m.prev, m, p.prev) < 0 && area(p.next, m, m.next) < 0;\n} // interlink polygon nodes in z-order\n\n\nfunction indexCurve(start, minX, minY, invSize) {\n  var p = start;\n\n  do {\n    if (p.z === 0) p.z = zOrder(p.x, p.y, minX, minY, invSize);\n    p.prevZ = p.prev;\n    p.nextZ = p.next;\n    p = p.next;\n  } while (p !== start);\n\n  p.prevZ.nextZ = null;\n  p.prevZ = null;\n  sortLinked(p);\n} // Simon Tatham's linked list merge sort algorithm\n// http://www.chiark.greenend.org.uk/~sgtatham/algorithms/listsort.html\n\n\nfunction sortLinked(list) {\n  var i,\n      p,\n      q,\n      e,\n      tail,\n      numMerges,\n      pSize,\n      qSize,\n      inSize = 1;\n\n  do {\n    p = list;\n    list = null;\n    tail = null;\n    numMerges = 0;\n\n    while (p) {\n      numMerges++;\n      q = p;\n      pSize = 0;\n\n      for (i = 0; i < inSize; i++) {\n        pSize++;\n        q = q.nextZ;\n        if (!q) break;\n      }\n\n      qSize = inSize;\n\n      while (pSize > 0 || qSize > 0 && q) {\n        if (pSize !== 0 && (qSize === 0 || !q || p.z <= q.z)) {\n          e = p;\n          p = p.nextZ;\n          pSize--;\n        } else {\n          e = q;\n          q = q.nextZ;\n          qSize--;\n        }\n\n        if (tail) tail.nextZ = e;else list = e;\n        e.prevZ = tail;\n        tail = e;\n      }\n\n      p = q;\n    }\n\n    tail.nextZ = null;\n    inSize *= 2;\n  } while (numMerges > 1);\n\n  return list;\n} // z-order of a point given coords and inverse of the longer side of data bbox\n\n\nfunction zOrder(x, y, minX, minY, invSize) {\n  // coords are transformed into non-negative 15-bit integer range\n  x = (x - minX) * invSize | 0;\n  y = (y - minY) * invSize | 0;\n  x = (x | x << 8) & 0x00FF00FF;\n  x = (x | x << 4) & 0x0F0F0F0F;\n  x = (x | x << 2) & 0x33333333;\n  x = (x | x << 1) & 0x55555555;\n  y = (y | y << 8) & 0x00FF00FF;\n  y = (y | y << 4) & 0x0F0F0F0F;\n  y = (y | y << 2) & 0x33333333;\n  y = (y | y << 1) & 0x55555555;\n  return x | y << 1;\n} // find the leftmost node of a polygon ring\n\n\nfunction getLeftmost(start) {\n  var p = start,\n      leftmost = start;\n\n  do {\n    if (p.x < leftmost.x || p.x === leftmost.x && p.y < leftmost.y) leftmost = p;\n    p = p.next;\n  } while (p !== start);\n\n  return leftmost;\n} // check if a point lies within a convex triangle\n\n\nfunction pointInTriangle(ax, ay, bx, by, cx, cy, px, py) {\n  return (cx - px) * (ay - py) >= (ax - px) * (cy - py) && (ax - px) * (by - py) >= (bx - px) * (ay - py) && (bx - px) * (cy - py) >= (cx - px) * (by - py);\n} // check if a diagonal between two polygon nodes is valid (lies in polygon interior)\n\n\nfunction isValidDiagonal(a, b) {\n  return a.next.i !== b.i && a.prev.i !== b.i && !intersectsPolygon(a, b) && ( // dones't intersect other edges\n  locallyInside(a, b) && locallyInside(b, a) && middleInside(a, b) && ( // locally visible\n  area(a.prev, a, b.prev) || area(a, b.prev, b)) || // does not create opposite-facing sectors\n  equals(a, b) && area(a.prev, a, a.next) > 0 && area(b.prev, b, b.next) > 0); // special zero-length case\n} // signed area of a triangle\n\n\nfunction area(p, q, r) {\n  return (q.y - p.y) * (r.x - q.x) - (q.x - p.x) * (r.y - q.y);\n} // check if two points are equal\n\n\nfunction equals(p1, p2) {\n  return p1.x === p2.x && p1.y === p2.y;\n} // check if two segments intersect\n\n\nfunction intersects(p1, q1, p2, q2) {\n  var o1 = sign(area(p1, q1, p2));\n  var o2 = sign(area(p1, q1, q2));\n  var o3 = sign(area(p2, q2, p1));\n  var o4 = sign(area(p2, q2, q1));\n  if (o1 !== o2 && o3 !== o4) return true; // general case\n\n  if (o1 === 0 && onSegment(p1, p2, q1)) return true; // p1, q1 and p2 are collinear and p2 lies on p1q1\n\n  if (o2 === 0 && onSegment(p1, q2, q1)) return true; // p1, q1 and q2 are collinear and q2 lies on p1q1\n\n  if (o3 === 0 && onSegment(p2, p1, q2)) return true; // p2, q2 and p1 are collinear and p1 lies on p2q2\n\n  if (o4 === 0 && onSegment(p2, q1, q2)) return true; // p2, q2 and q1 are collinear and q1 lies on p2q2\n\n  return false;\n} // for collinear points p, q, r, check if point q lies on segment pr\n\n\nfunction onSegment(p, q, r) {\n  return q.x <= Math.max(p.x, r.x) && q.x >= Math.min(p.x, r.x) && q.y <= Math.max(p.y, r.y) && q.y >= Math.min(p.y, r.y);\n}\n\nfunction sign(num) {\n  return num > 0 ? 1 : num < 0 ? -1 : 0;\n} // check if a polygon diagonal intersects any polygon segments\n\n\nfunction intersectsPolygon(a, b) {\n  var p = a;\n\n  do {\n    if (p.i !== a.i && p.next.i !== a.i && p.i !== b.i && p.next.i !== b.i && intersects(p, p.next, a, b)) return true;\n    p = p.next;\n  } while (p !== a);\n\n  return false;\n} // check if a polygon diagonal is locally inside the polygon\n\n\nfunction locallyInside(a, b) {\n  return area(a.prev, a, a.next) < 0 ? area(a, b, a.next) >= 0 && area(a, a.prev, b) >= 0 : area(a, b, a.prev) < 0 || area(a, a.next, b) < 0;\n} // check if the middle point of a polygon diagonal is inside the polygon\n\n\nfunction middleInside(a, b) {\n  var p = a,\n      inside = false,\n      px = (a.x + b.x) / 2,\n      py = (a.y + b.y) / 2;\n\n  do {\n    if (p.y > py !== p.next.y > py && p.next.y !== p.y && px < (p.next.x - p.x) * (py - p.y) / (p.next.y - p.y) + p.x) inside = !inside;\n    p = p.next;\n  } while (p !== a);\n\n  return inside;\n} // link two polygon vertices with a bridge; if the vertices belong to the same ring, it splits polygon into two;\n// if one belongs to the outer ring and another to a hole, it merges it into a single ring\n\n\nfunction splitPolygon(a, b) {\n  var a2 = new Node(a.i, a.x, a.y),\n      b2 = new Node(b.i, b.x, b.y),\n      an = a.next,\n      bp = b.prev;\n  a.next = b;\n  b.prev = a;\n  a2.next = an;\n  an.prev = a2;\n  b2.next = a2;\n  a2.prev = b2;\n  bp.next = b2;\n  b2.prev = bp;\n  return b2;\n} // create a node and optionally link it with previous one (in a circular doubly linked list)\n\n\nfunction insertNode(i, x, y, last) {\n  var p = new Node(i, x, y);\n\n  if (!last) {\n    p.prev = p;\n    p.next = p;\n  } else {\n    p.next = last.next;\n    p.prev = last;\n    last.next.prev = p;\n    last.next = p;\n  }\n\n  return p;\n}\n\nfunction removeNode(p) {\n  p.next.prev = p.prev;\n  p.prev.next = p.next;\n  if (p.prevZ) p.prevZ.nextZ = p.nextZ;\n  if (p.nextZ) p.nextZ.prevZ = p.prevZ;\n}\n\nfunction Node(i, x, y) {\n  // vertex index in coordinates array\n  this.i = i; // vertex coordinates\n\n  this.x = x;\n  this.y = y; // previous and next vertex nodes in a polygon ring\n\n  this.prev = null;\n  this.next = null; // z-order curve value\n\n  this.z = 0; // previous and next nodes in z-order\n\n  this.prevZ = null;\n  this.nextZ = null; // indicates whether this is a steiner point\n\n  this.steiner = false;\n} // return a percentage difference between the polygon area and its triangulation area;\n// used to verify correctness of triangulation\n\n\nearcut.deviation = function (data, holeIndices, dim, triangles) {\n  var hasHoles = holeIndices && holeIndices.length;\n  var outerLen = hasHoles ? holeIndices[0] * dim : data.length;\n  var polygonArea = Math.abs(signedArea(data, 0, outerLen, dim));\n\n  if (hasHoles) {\n    for (var i = 0, len = holeIndices.length; i < len; i++) {\n      var start = holeIndices[i] * dim;\n      var end = i < len - 1 ? holeIndices[i + 1] * dim : data.length;\n      polygonArea -= Math.abs(signedArea(data, start, end, dim));\n    }\n  }\n\n  var trianglesArea = 0;\n\n  for (i = 0; i < triangles.length; i += 3) {\n    var a = triangles[i] * dim;\n    var b = triangles[i + 1] * dim;\n    var c = triangles[i + 2] * dim;\n    trianglesArea += Math.abs((data[a] - data[c]) * (data[b + 1] - data[a + 1]) - (data[a] - data[b]) * (data[c + 1] - data[a + 1]));\n  }\n\n  return polygonArea === 0 && trianglesArea === 0 ? 0 : Math.abs((trianglesArea - polygonArea) / polygonArea);\n};\n\nfunction signedArea(data, start, end, dim) {\n  var sum = 0;\n\n  for (var i = start, j = end - dim; i < end; i += dim) {\n    sum += (data[j] - data[i]) * (data[i + 1] + data[j + 1]);\n    j = i;\n  }\n\n  return sum;\n} // turn a polygon in a multi-dimensional array form (e.g. as in GeoJSON) into a form Earcut accepts\n\n\nearcut.flatten = function (data) {\n  var dim = data[0][0].length,\n      result = {\n    vertices: [],\n    holes: [],\n    dimensions: dim\n  },\n      holeIndex = 0;\n\n  for (var i = 0; i < data.length; i++) {\n    for (var j = 0; j < data[i].length; j++) {\n      for (var d = 0; d < dim; d++) result.vertices.push(data[i][j][d]);\n    }\n\n    if (i > 0) {\n      holeIndex += data[i - 1].length;\n      result.holes.push(holeIndex);\n    }\n  }\n\n  return result;\n};\n\n//# sourceURL=webpack:////Users/mu/node_modules/earcut/src/earcut.js?");

/***/ }),

/***/ "../../node_modules/nav2d/src/math.js":
/*!************************************************!*\
  !*** /Users/mu/node_modules/nav2d/src/math.js ***!
  \************************************************/
/*! exports provided: EPS, Vector, dot, cross, isclose, clip */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"EPS\", function() { return EPS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Vector\", function() { return Vector; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"dot\", function() { return dot; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"cross\", function() { return cross; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"isclose\", function() { return isclose; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"clip\", function() { return clip; });\nconst EPS = 1e-8;\nclass Vector {\n  constructor(x, y) {\n    if (typeof x !== \"number\" || typeof y !== \"number\") {\n      throw new Error(\"Vector components must be numbers.\");\n    }\n\n    this.x = x;\n    this.y = y;\n  }\n\n  _normOther(other) {\n    if (typeof other == \"number\") {\n      return new Vector(other, other);\n    }\n\n    return other;\n  }\n\n  add(other) {\n    other = this._normOther(other);\n    return new Vector(this.x + other.x, this.y + other.y);\n  }\n\n  sub(other) {\n    other = this._normOther(other);\n    return new Vector(this.x - other.x, this.y - other.y);\n  }\n\n  mul(other) {\n    other = this._normOther(other);\n    return new Vector(this.x * other.x, this.y * other.y);\n  }\n\n  div(other) {\n    other = this._normOther(other);\n    return new Vector(this.x / other.x, this.y / other.y);\n  }\n\n  length() {\n    return Math.sqrt(this.x * this.x + this.y * this.y);\n  }\n\n  equals(other) {\n    return isclose(this.x, other.x) && isclose(this.y, other.y);\n  }\n\n  angle(other) {\n    return Math.acos(clip(-1, 1, dot(this, other) / (this.length() * other.length())));\n  }\n\n  counterclockwiseAngle(other) {\n    const angle = this.angle(other);\n    return cross(this, other) >= 0 ? angle : 2 * Math.PI - angle;\n  }\n\n  toString() {\n    return `{ x: ${this.x}, y: ${this.y} }`;\n  }\n\n}\nfunction dot(a, b) {\n  return a.x * b.x + a.y * b.y;\n}\nfunction cross(a, b) {\n  return a.x * b.y - a.y * b.x;\n}\nfunction isclose(a, b, eps = EPS) {\n  return a > b - eps && a < b + eps;\n}\nfunction clip(a, b, v) {\n  if (v < a) return a;\n  if (v > b) return b;\n  return v;\n}\n\n//# sourceURL=webpack:////Users/mu/node_modules/nav2d/src/math.js?");

/***/ }),

/***/ "../../node_modules/nav2d/src/nav2d.js":
/*!*************************************************!*\
  !*** /Users/mu/node_modules/nav2d/src/nav2d.js ***!
  \*************************************************/
/*! exports provided: Point, Vector, isclose, clip, dot, cross, Edge, Polygon, NavMesh */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Point\", function() { return Point; });\n/* harmony import */ var _math__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./math */ \"../../node_modules/nav2d/src/math.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Vector\", function() { return _math__WEBPACK_IMPORTED_MODULE_0__[\"Vector\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"isclose\", function() { return _math__WEBPACK_IMPORTED_MODULE_0__[\"isclose\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"clip\", function() { return _math__WEBPACK_IMPORTED_MODULE_0__[\"clip\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"dot\", function() { return _math__WEBPACK_IMPORTED_MODULE_0__[\"dot\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"cross\", function() { return _math__WEBPACK_IMPORTED_MODULE_0__[\"cross\"]; });\n\n/* harmony import */ var _navmesh__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./navmesh */ \"../../node_modules/nav2d/src/navmesh.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Edge\", function() { return _navmesh__WEBPACK_IMPORTED_MODULE_1__[\"Edge\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"Polygon\", function() { return _navmesh__WEBPACK_IMPORTED_MODULE_1__[\"Polygon\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"NavMesh\", function() { return _navmesh__WEBPACK_IMPORTED_MODULE_1__[\"NavMesh\"]; });\n\n\n\nconst Point = _math__WEBPACK_IMPORTED_MODULE_0__[\"Vector\"];\n\n\n//# sourceURL=webpack:////Users/mu/node_modules/nav2d/src/nav2d.js?");

/***/ }),

/***/ "../../node_modules/nav2d/src/navmesh.js":
/*!***************************************************!*\
  !*** /Users/mu/node_modules/nav2d/src/navmesh.js ***!
  \***************************************************/
/*! exports provided: Edge, Polygon, NavMesh */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Edge\", function() { return Edge; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"Polygon\", function() { return Polygon; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"NavMesh\", function() { return NavMesh; });\n/* harmony import */ var uuid__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! uuid */ \"../../node_modules/uuid/dist/esm-browser/index.js\");\n/* harmony import */ var point_in_polygon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! point-in-polygon */ \"../../node_modules/point-in-polygon/index.js\");\n/* harmony import */ var point_in_polygon__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(point_in_polygon__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var earcut__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! earcut */ \"../../node_modules/earcut/src/earcut.js\");\n/* harmony import */ var earcut__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(earcut__WEBPACK_IMPORTED_MODULE_2__);\n/* harmony import */ var simple_quadtree__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! simple-quadtree */ \"../../node_modules/simple-quadtree/qtree.js\");\n/* harmony import */ var simple_quadtree__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(simple_quadtree__WEBPACK_IMPORTED_MODULE_3__);\n/* harmony import */ var tinyqueue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! tinyqueue */ \"../../node_modules/tinyqueue/index.js\");\n/* harmony import */ var _math__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./math */ \"../../node_modules/nav2d/src/math.js\");\n\n\n\n\n\n\n\nfunction _normalizePoint(point) {\n  if (point instanceof Array) {\n    return new _math__WEBPACK_IMPORTED_MODULE_5__[\"Vector\"](...point);\n  } else if (point instanceof _math__WEBPACK_IMPORTED_MODULE_5__[\"Vector\"]) {\n    return point;\n  } else if (point.hasOwnProperty(\"x\") && point.hasOwnProperty(\"y\")) {\n    return new _math__WEBPACK_IMPORTED_MODULE_5__[\"Vector\"](point.x, point.y);\n  }\n}\n\nclass Edge {\n  constructor(p1, p2) {\n    this._uuid = Object(uuid__WEBPACK_IMPORTED_MODULE_0__[\"v4\"])();\n    this.p1 = _normalizePoint(p1);\n    this.p2 = _normalizePoint(p2);\n  }\n\n  length() {\n    return this.p1.sub(this.p2).length();\n  }\n\n  direction() {\n    return this.p1.sub(this.p2);\n  }\n\n  onEdge(point) {\n    point = _normalizePoint(point);\n    const pointVec = this.p1.sub(point);\n    if (!this.parallel(pointVec)) return false; // test that it's not only collinear, but falls between p1 and p2\n\n    const direction = this.direction();\n    const len = this.length();\n    const component = Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"dot\"])(direction, pointVec) / (len * len);\n    return component >= 0 && component <= 1;\n  }\n\n  parallel(other) {\n    const otherDirection = other instanceof _math__WEBPACK_IMPORTED_MODULE_5__[\"Vector\"] ? other : other.p1.sub(other.p2);\n    return Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"isclose\"])(Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"cross\"])(this.direction(), otherDirection), 0);\n  }\n\n  collinear(other) {\n    const direction = this.direction();\n    const otherVec1 = this.p1.sub(other.p1);\n    const otherVec2 = this.p1.sub(other.p2);\n    return Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"isclose\"])(Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"cross\"])(direction, otherVec1), 0) && Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"isclose\"])(Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"cross\"])(direction, otherVec2), 0);\n  }\n\n  overlap(other) {\n    if (!this.collinear(other)) {\n      throw new Error(\"Cannot compute overlap of two non-collinear edges.\");\n    }\n\n    let endpoints = [];\n    if (this.onEdge(other.p1)) endpoints.push(other.p1);\n    if (this.onEdge(other.p2)) endpoints.push(other.p2);\n    if (other.onEdge(this.p1)) endpoints.push(this.p1);\n    if (other.onEdge(this.p2)) endpoints.push(this.p2); // enpoints can also be the an array with twice the same point,\n    // which is fine as it yields a zero-length edge\n\n    if (endpoints.length > 2) {\n      endpoints = endpoints.filter((p, i) => endpoints.findIndex(op => op.equals(p)) === i);\n    }\n\n    if (!endpoints.length) {\n      return null;\n    } else if (endpoints.length == 1) {\n      endpoints = [endpoints[0], endpoints[0]];\n    }\n\n    return new Edge(...endpoints);\n  }\n\n  equals(other) {\n    return this.p1.equals(other.p1) && this.p2.equals(other.p2) || this.p1.equals(other.p2) && this.p2.equals(other.p1);\n  }\n\n}\nclass Polygon {\n  constructor(points) {\n    this._uuid = Object(uuid__WEBPACK_IMPORTED_MODULE_0__[\"v4\"])();\n    this.points = points.map(_normalizePoint);\n    this.bounds = this._computeBounds();\n  }\n\n  _computeBounds() {\n    return this.points.reduce((a, p) => [Math.min(p.x, a[0]), Math.min(p.y, a[1]), Math.max(p.x, a[2]), Math.max(p.y, a[3])], [Infinity, Infinity, -Infinity, -Infinity]);\n  }\n\n  edges() {\n    return this.points.map((point, i) => new Edge(i == 0 ? this.points[this.points.length - 1] : this.points[i - 1], point));\n  }\n\n  centroid() {\n    return this.points.reduce((acc, point) => acc.add(point), new _math__WEBPACK_IMPORTED_MODULE_5__[\"Vector\"](0, 0)).div(this.points.length);\n  }\n\n  centroidDistance(other) {\n    const centroidVector = this.centroid().sub(other.centroid());\n    return centroidVector.length();\n  }\n\n  contains(point) {\n    point = _normalizePoint(point);\n    const polyPoints = this.points.map(this._toPointArray);\n    return point_in_polygon__WEBPACK_IMPORTED_MODULE_1___default()(this._toPointArray(point), polyPoints) || !!this.onEdge(point);\n  }\n\n  _toPointArray(point) {\n    return [point.x, point.y];\n  }\n\n  onEdge(point) {\n    point = _normalizePoint(point);\n\n    for (const edge of this.edges()) {\n      if (edge.onEdge(point)) return edge;\n    }\n\n    return null;\n  }\n\n  touches(otherEdge) {\n    for (const edge of this.edges()) {\n      if ((edge.onEdge(otherEdge.p1) || edge.onEdge(otherEdge.p2)) && edge.collinear(otherEdge)) {\n        return edge;\n      }\n    }\n\n    return null;\n  }\n\n  boundsSize() {\n    const [minx, miny, maxx, maxy] = this.bounds;\n    return {\n      x: minx,\n      y: miny,\n      w: maxx - minx,\n      h: maxy - miny\n    };\n  }\n\n}\nclass NavMesh {\n  constructor(polygons, costFunc = null, heuristicFunc = null) {\n    this._uuid = Object(uuid__WEBPACK_IMPORTED_MODULE_0__[\"v4\"])();\n    this.polygons = this._triangulate(polygons).map(points => new Polygon(points));\n    this.costFunc = costFunc;\n    this.heuristicFunc = heuristicFunc; // This will be used to check point collision with\n    // triangles. This should be much smaller that the typical\n    // size of your mesh triangles to avoid checking too many\n    // triangles for collision.\n\n    this.pointQuerySize = 0.01;\n\n    this._buildQuadtree();\n\n    this._buildNeighbors();\n  }\n\n  _triangulate(polygons) {\n    const triangles = [];\n\n    for (const poly of polygons) {\n      const trianglesIndices = earcut__WEBPACK_IMPORTED_MODULE_2___default()(this._flatten(poly));\n\n      for (let i = 0; i < trianglesIndices.length / 3; i++) {\n        const indices = trianglesIndices.slice(i * 3, i * 3 + 3);\n        triangles.push(indices.map(j => poly[j]));\n      }\n    }\n\n    return triangles;\n  }\n\n  _flatten(points) {\n    const flatPoints = [];\n\n    for (const point of points) {\n      if (point instanceof Array) {\n        flatPoints.push(...point);\n      } else {\n        flatPoints.push(point.x, point.y);\n      }\n    }\n\n    return flatPoints;\n  }\n\n  _buildQuadtree() {\n    // Use quad tree because the naive approach of iterating\n    // with two nested for loops over the polygons has performance\n    // n*lon(n), which for a 30x30 grid already takes a minute.\n    // This thing, for the same grid, takes 1 second, and scales linearly.\n    this.qt = simple_quadtree__WEBPACK_IMPORTED_MODULE_3___default()(-Infinity, -Infinity, Infinity, Infinity);\n\n    for (const poly of this.polygons) {\n      this.qt.put({ ...poly.boundsSize(),\n        polygon: poly\n      });\n    }\n  }\n\n  _buildNeighbors() {\n    this.polygons.forEach(polygon => polygon.neighbors = {});\n\n    for (let i = 0; i < this.polygons.length; i++) {\n      const poly1 = this.polygons[i];\n\n      for (const poly2wrap of this.qt.get(poly1.boundsSize())) {\n        const poly2 = poly2wrap.polygon;\n        if (poly1 === poly2) continue;\n        if (poly1.neighbors.hasOwnProperty(poly2._uuid)) continue;\n\n        const portal = this._computePortal(poly1, poly2);\n\n        if (portal !== null && portal.length() > 0) {\n          // Ensure that portal points are given in left-to-right order, viewed from the centroid of the polygon\n          let [p1, p2] = this._orderLeftRight(poly1.centroid(), portal.p1, portal.p2);\n\n          poly1.neighbors[poly2._uuid] = {\n            polygon: poly2,\n            portal: new Edge(p1, p2)\n          };\n          poly2.neighbors[poly1._uuid] = {\n            polygon: poly1,\n            portal: new Edge(p2, p1)\n          };\n        }\n      }\n    }\n  }\n\n  _computePortal(poly1, poly2) {\n    for (const edge1 of poly1.edges()) {\n      const edge2 = poly2.touches(edge1);\n\n      if (edge2 !== null) {\n        return edge1.overlap(edge2);\n      }\n    }\n\n    return null;\n  }\n\n  findPath(from, to) {\n    from = _normalizePoint(from);\n    to = _normalizePoint(to);\n\n    const path = this._findPath(from, to);\n\n    return path && this._funnel(from, to, path);\n  }\n\n  _findPath(from, to) {\n    // This is the A* algorithm\n    const fromPoly = this._findContainingPolygon(from);\n\n    const toPoly = this._findContainingPolygon(to);\n\n    if (fromPoly === null || toPoly === null) return null;\n    const frontier = new tinyqueue__WEBPACK_IMPORTED_MODULE_4__[\"default\"]([{\n      cost: 0,\n      polygon: fromPoly\n    }], (a, b) => a.cost - b.cost);\n    const cameFrom = {\n      [fromPoly._uuid]: null\n    };\n    const cost = {\n      [fromPoly._uuid]: 0\n    };\n\n    while (frontier.length) {\n      const current = frontier.pop().polygon;\n\n      if (current._uuid === toPoly._uuid) {\n        break;\n      }\n\n      for (const {\n        polygon: next\n      } of Object.values(current.neighbors)) {\n        const nextCost = cost[current._uuid] + this._computeCost(current, next);\n\n        if ( // node not yet visited\n        !cost.hasOwnProperty(next._uuid) || // this path to node has lower cost\n        nextCost < cost[next._uuid]) {\n          frontier.push({\n            cost: nextCost + this._heuristic(next, toPoly),\n            polygon: next\n          });\n          cost[next._uuid] = nextCost;\n          cameFrom[next._uuid] = current;\n        }\n      }\n    }\n\n    return this._reconstructPath(toPoly, cameFrom);\n  }\n\n  _computeDistance(a, b) {\n    return a.centroidDistance(b);\n  }\n\n  _computeCost(a, b) {\n    if (this.costFunc !== null) {\n      const portal = a.neighbors[b._uuid].portal;\n      return this.costFunc(a, b, portal);\n    }\n\n    return this._computeDistance(a, b);\n  }\n\n  _heuristic(poly, to) {\n    if (poly._uuid == to._uuid) return 0;\n    if (this.heuristicFunc !== null) return this.heuristicFunc(poly, to);\n    return this._computeDistance(poly, to);\n  }\n\n  _findContainingPolygon(point) {\n    const halfQuerySize = this.pointQuerySize / 2;\n    const bounds = {\n      x: point.x - halfQuerySize,\n      y: point.y - halfQuerySize,\n      w: this.pointQuerySize,\n      h: this.pointQuerySize\n    };\n\n    for (const poly of this.qt.get(bounds)) {\n      if (poly.polygon.contains(point)) return poly.polygon;\n    }\n\n    return null;\n  }\n\n  _reconstructPath(to, cameFrom) {\n    if (!cameFrom.hasOwnProperty(to._uuid)) {\n      // Disconnected\n      return null;\n    }\n\n    let current = to;\n    const path = [];\n\n    while (current !== null) {\n      path.push(current);\n      current = cameFrom[current._uuid];\n    }\n\n    return path.reverse();\n  }\n  /** Funnel algorithm, following https://medium.com/@reza.teshnizi/the-funnel-algorithm-explained-visually-41e374172d2d */\n\n\n  _funnel(from, to, path) {\n    if (path.length === 0) {\n      throw new Error(\"Path cannot be empty.\");\n    } else if (path.length === 1) {\n      return [from, to];\n    }\n\n    const tail = [from];\n    const left = [];\n    const right = []; // Initialize funnel\n\n    const initialPortal = path[0].neighbors[path[1]._uuid].portal;\n    left.push(initialPortal.p1);\n    right.push(initialPortal.p2); // Iterate over portals\n\n    for (let i = 1; i < path.length - 1; i++) {\n      const poly = path[i];\n      const nextPoly = path[i + 1];\n      const portal = poly.neighbors[nextPoly._uuid].portal; // The portal end points are in left-to-right order, viewed from the inside of the polygon.\n\n      this._extendFunnel(tail, left, right, portal.p1, portal.p2);\n    } // Close funnel to endpoint\n\n\n    this._extendFunnel(tail, left, right, to, to);\n\n    return tail;\n  }\n\n  _extendFunnel(tail, left, right, leftPoint, rightPoint) {\n    // Extend funnel on the left\n    this._extendFunnelSide(tail, left, right, true, leftPoint); // Extend funnel on the right\n\n\n    this._extendFunnelSide(tail, left, right, false, rightPoint);\n  }\n\n  _extendFunnelSide(tail, left, right, extendLeft, newPoint) {\n    const apex = tail[tail.length - 1]; // We pretend to be in the `expandLeft` case here. Otherwise flip.\n\n    if (!extendLeft) {\n      [left, right] = [right, left];\n    } // If `newPoint` is the end point of the left side of the funnel, skip it.\n\n\n    const lastLeft = left.length === 0 ? tail[tail.length - 1] : left[left.length - 1];\n\n    if (newPoint.equals(lastLeft)) {\n      return;\n    } // Determine how far to shrink the funnel\n\n\n    let j = this._findFirstLeftOfPoint(apex, left, newPoint, true, !extendLeft); // All points in `left` with index `< j` are right of `newPoint` and\n    // all points in `left` with index `>= j` are left of or at the same angle as `newPoint`.\n\n\n    left.length = j; // Shrink funnel if `j < left.length`\n\n    left.push(newPoint);\n\n    if (j === 0) {\n      // If the funnel shrunk all the way on the left, it might collapse to the right.\n      // Determine how far it needs to collapse\n      let k = this._findFirstLeftOfPoint(apex, right, newPoint, false, extendLeft); // All points in `right` with index `< k` are left of or at the same angle as `newPoint` and\n      // all points in `right` with index `>= k` are right of `newPoint`.\n\n\n      tail.push(...right.splice(0, k)); // Collapse funnel if `k > 0`\n    }\n  }\n  /**\n   * Given an array `arr` of points, find the index of the first one that is\n   * on the left side of a given point `p`, viewed from `origin`. If no such\n   * point exists, the length of the list is returned.\n   *\n   * If `flip` is true, find the first that is on the right side instead.\n   *\n   * If `acceptColinear` is true, the returned point may also be colinear.\n   */\n\n\n  _findFirstLeftOfPoint(origin, arr, p, acceptColinear, flip) {\n    let i;\n\n    for (i = 0; i < arr.length; i++) {\n      const found = flip ? this._isInLeftRightOrder(origin, p, arr[i], acceptColinear) : this._isInLeftRightOrder(origin, arr[i], p, acceptColinear);\n      if (found) return i;\n    }\n\n    return i;\n  }\n  /**\n   * Are the points `p1` and `p2` in left-to-right order, viewed from `origin`?\n   * If points are colinear, the value of `acceptColinear` is returned.\n   */\n\n\n  _isInLeftRightOrder(origin, p1, p2, acceptColinear = false) {\n    const vec1 = p1.sub(origin);\n    const vec2 = p2.sub(origin);\n    const c = Object(_math__WEBPACK_IMPORTED_MODULE_5__[\"cross\"])(vec1, vec2);\n    return acceptColinear ? c <= 0 : c < 0;\n  }\n  /** Returns the points `p1` and `p2` in left-to-right order, viewed from `origin`. */\n\n\n  _orderLeftRight(origin, p1, p2) {\n    if (this._isInLeftRightOrder(origin, p1, p2)) {\n      return [p1, p2];\n    } else {\n      return [p2, p1];\n    }\n  }\n\n}\n\n//# sourceURL=webpack:////Users/mu/node_modules/nav2d/src/navmesh.js?");

/***/ }),

/***/ "../../node_modules/point-in-polygon/flat.js":
/*!*******************************************************!*\
  !*** /Users/mu/node_modules/point-in-polygon/flat.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("module.exports = function pointInPolygonFlat(point, vs, start, end) {\n  var x = point[0],\n      y = point[1];\n  var inside = false;\n  if (start === undefined) start = 0;\n  if (end === undefined) end = vs.length;\n  var len = (end - start) / 2;\n\n  for (var i = 0, j = len - 1; i < len; j = i++) {\n    var xi = vs[start + i * 2 + 0],\n        yi = vs[start + i * 2 + 1];\n    var xj = vs[start + j * 2 + 0],\n        yj = vs[start + j * 2 + 1];\n    var intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;\n    if (intersect) inside = !inside;\n  }\n\n  return inside;\n};\n\n//# sourceURL=webpack:////Users/mu/node_modules/point-in-polygon/flat.js?");

/***/ }),

/***/ "../../node_modules/point-in-polygon/index.js":
/*!********************************************************!*\
  !*** /Users/mu/node_modules/point-in-polygon/index.js ***!
  \********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("var pointInPolygonFlat = __webpack_require__(/*! ./flat.js */ \"../../node_modules/point-in-polygon/flat.js\");\n\nvar pointInPolygonNested = __webpack_require__(/*! ./nested.js */ \"../../node_modules/point-in-polygon/nested.js\");\n\nmodule.exports = function pointInPolygon(point, vs, start, end) {\n  if (vs.length > 0 && Array.isArray(vs[0])) {\n    return pointInPolygonNested(point, vs, start, end);\n  } else {\n    return pointInPolygonFlat(point, vs, start, end);\n  }\n};\n\nmodule.exports.nested = pointInPolygonNested;\nmodule.exports.flat = pointInPolygonFlat;\n\n//# sourceURL=webpack:////Users/mu/node_modules/point-in-polygon/index.js?");

/***/ }),

/***/ "../../node_modules/point-in-polygon/nested.js":
/*!*********************************************************!*\
  !*** /Users/mu/node_modules/point-in-polygon/nested.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

eval("// ray-casting algorithm based on\n// https://wrf.ecse.rpi.edu/Research/Short_Notes/pnpoly.html\nmodule.exports = function pointInPolygonNested(point, vs, start, end) {\n  var x = point[0],\n      y = point[1];\n  var inside = false;\n  if (start === undefined) start = 0;\n  if (end === undefined) end = vs.length;\n  var len = end - start;\n\n  for (var i = 0, j = len - 1; i < len; j = i++) {\n    var xi = vs[i + start][0],\n        yi = vs[i + start][1];\n    var xj = vs[j + start][0],\n        yj = vs[j + start][1];\n    var intersect = yi > y !== yj > y && x < (xj - xi) * (y - yi) / (yj - yi) + xi;\n    if (intersect) inside = !inside;\n  }\n\n  return inside;\n};\n\n//# sourceURL=webpack:////Users/mu/node_modules/point-in-polygon/nested.js?");

/***/ }),

/***/ "../../node_modules/simple-quadtree/qtree.js":
/*!*******************************************************!*\
  !*** /Users/mu/node_modules/simple-quadtree/qtree.js ***!
  \*******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("/**\n*\n* simple-quadtree is a minimal quadtree implementation that supports simple put, get,\n* remove and clear operations on objects having a x, y position and w, h dimension.\n*\n* Copyright (c) 2013 Antti Saarinen <antti.p.saarinen@gmail.com>\n* https://github.com/asaarinen/qtree\n*\n*/\nfunction QuadTree(x, y, w, h, options) {\n  if (typeof x != 'number' || isNaN(x)) x = 0;\n  if (typeof y != 'number' || isNaN(y)) y = 0;\n  if (typeof w != 'number' || isNaN(w)) w = 10;\n  if (typeof h != 'number' || isNaN(h)) h = 10;\n  var maxc = 25;\n  var leafratio = 0.5;\n\n  if (options) {\n    if (typeof options.maxchildren == 'number') if (options.maxchildren > 0) maxc = options.maxchildren;\n    if (typeof options.leafratio == 'number') if (options.leafratio >= 0) leafratio = options.leafratio;\n  } // validate an input object\n\n\n  function validate(obj) {\n    if (!obj) return false;\n    if (typeof obj.x != 'number' || typeof obj.y != 'number' || typeof obj.w != 'number' || typeof obj.h != 'number') return false;\n    if (isNaN(obj.x) || isNaN(obj.y) || isNaN(obj.w) || isNaN(obj.h)) return false;\n    if (obj.w < 0 || obj.h < 0) return false;\n    return true;\n  } // test for deep equality for x,y,w,h\n\n\n  function isequal(o1, o2) {\n    if (o1.x == o2.x && o1.y == o2.y && o1.w == o2.w && o1.h == o2.h) return true;\n    return false;\n  } // create a new quadtree node\n\n\n  function createnode(x, y, w, h) {\n    return {\n      x: x,\n      y: y,\n      w: w,\n      h: h,\n      c: [],\n      l: [],\n      n: []\n    };\n  } // root node used by this quadtree\n\n\n  var root = createnode(x, y, w, h); // calculate distance between two points\n\n  function distance(x1, y1, x2, y2) {\n    return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));\n  } // calculate distance between a point and a line (segment)\n\n\n  function distancePL(x, y, x1, y1, dx1, dy1, len1) {\n    if (!len1) // in case length is not provided, assume a line \n      len1 = -1; // x = x1 + s * dx1 + t * dy1\n    // y = y1 + s * dy1 - t * dx1\n    // x * dy1 - y * dx1 = x1 * dy1 - y1 * dx1 + \n    //                     t * ( dy1 * dy1 + dx1 * dx1 )\n\n    var t = dx1 * dx1 + dy1 * dy1;\n    if (t == 0) return null;else {\n      t = (x * dy1 - y * dx1 - x1 * dy1 + y1 * dx1) / t;\n      if (Math.abs(dx1) > Math.abs(dy1)) var s = (x - x1 - t * dy1) / dx1;else var s = (y - y1 + t * dx1) / dy1;\n      if (s >= 0 && s <= len1 || len1 < 0) return {\n        s: s,\n        t: t,\n        x: x1 + s * dx1,\n        y: y1 + s * dy1,\n        dist: Math.abs(t)\n      };else if (s < 0) {\n        var dist = distance(x, y, x1, y1);\n        return {\n          s: s,\n          dist: dist\n        };\n      } else {\n        var dist = distance(x, y, x1 + len1 * dx1, y1 + len1 * dy1);\n        return {\n          s: s,\n          dist: dist\n        };\n      }\n    }\n  } // does a line and a rectangle overlap ?\n\n\n  function overlap_line(o1, o2, buf) {\n    if (!o1 || !o2) return true;\n    var dist = distancePL(o2.x + 0.5 * o2.w, o2.y + 0.5 * o2.h, o1.x, o1.y, o1.dx, o1.dy, o1.dist);\n\n    if (dist) {\n      dist.dist -= buf;\n      if (dist.dist < 0) return true;\n      if (dist.dist * dist.dist <= o2.w * o2.w + o2.h * o2.h) return true;\n    }\n\n    return false;\n  } // do two rectangles overlap ?\n\n\n  function overlap_rect(o1, o2, buf) {\n    if (!o1 || !o2) return true;\n    if (o1.x + o1.w < o2.x - buf || o1.y + o1.h < o2.y - buf || o1.x - buf > o2.x + o2.w || o1.y - buf > o2.y + o2.h) return false;\n    return true;\n  }\n\n  function isleaf(node, obj) {\n    var leaf = false;\n    if (obj.w * obj.h > node.w * node.h * leafratio) leaf = true;\n    if (obj.x < node.x || obj.y < node.y || obj.x + obj.w > node.x + node.w || obj.y + obj.h > node.y + node.h) leaf = true;\n    var childnode = null;\n\n    for (var ni = 0; ni < node.n.length; ni++) if (overlap_rect(obj, node.n[ni], 0)) {\n      if (childnode) {\n        // multiple hits\n        leaf = true;\n        break;\n      } else childnode = node.n[ni];\n    }\n\n    return {\n      leaf: leaf,\n      childnode: childnode\n    };\n  } // put an object to one of the child nodes of this node\n\n\n  function put_to_nodes(node, obj) {\n    var leaf = isleaf(node, obj);\n    if (leaf.leaf) node.l.push(obj);else if (leaf.childnode) put(leaf.childnode, obj);else return;\n  }\n\n  function update_coords(obj, updatedcoords) {\n    obj.x = typeof updatedcoords.x == 'number' ? updatedcoords.x : obj.x;\n    obj.y = typeof updatedcoords.y == 'number' ? updatedcoords.y : obj.y;\n    obj.w = typeof updatedcoords.w == 'number' ? updatedcoords.w : obj.w;\n    obj.h = typeof updatedcoords.h == 'number' ? updatedcoords.h : obj.h;\n  }\n\n  function update(node, obj, attr, updatedcoords) {\n    if (typeof attr == 'object' && typeof updatedcoords == 'undefined') {\n      updatedcoords = attr;\n      attr = false;\n    }\n\n    if (!validate(obj) || typeof updatedcoords == 'undefined') return false;\n    if (!attr) attr = false;else if (typeof attr != 'string') attr = 'id';\n    var count = 0;\n\n    for (var ci = 0; ci < node.c.length; ci++) if (attr && node.c[ci][attr] == obj[attr] || !attr && isequal(node.c[ci], obj)) {\n      // found the object to be updated\n      var orig = node.c[ci];\n      update_coords(orig, updatedcoords);\n\n      if (orig.x > node.x + node.w || orig.y > node.y + node.h || orig.x + orig.w < node.x || orig.y + orig.h < node.y) {\n        // this object needs to be removed and added\n        node.c.splice(ci, 1);\n        put(root, orig);\n      } // updated object is still inside same node\n\n\n      return true;\n    }\n\n    for (var ci = 0; ci < node.l.length; ci++) if (attr && node.l[ci][attr] == obj[attr] || !attr && isequal(node.l[ci], obj)) {\n      var orig = node.l[ci];\n      update_coords(orig, updatedcoords); // found the object to be updated\n\n      if (orig.x > node.x + node.w || orig.y > node.y + node.h || orig.x + orig.w < node.x || orig.y + orig.h < node.y) {\n        // this object needs to be removed and added \n        node.l.splice(ci, 1);\n        put(root, orig);\n      } // updated object is still inside same node\n\n\n      return true;\n    }\n\n    var leaf = isleaf(node, obj);\n    if (!leaf.leaf && leaf.childnode) if (update(leaf.childnode, obj, attr)) return true;\n    return false;\n  } // remove an object from this node\n\n\n  function remove(node, obj, attr) {\n    if (!validate(obj)) return 0;\n    if (!attr) attr = false;else if (typeof attr != 'string') attr = 'id';\n    var count = 0;\n\n    for (var ci = 0; ci < node.c.length; ci++) if (attr && node.c[ci][attr] == obj[attr] || !attr && isequal(node.c[ci], obj)) {\n      count++;\n      node.c.splice(ci, 1);\n      ci--;\n    }\n\n    for (var ci = 0; ci < node.l.length; ci++) if (attr && node.l[ci][attr] == obj[attr] || !attr && isequal(node.l[ci], obj)) {\n      count++;\n      node.l.splice(ci, 1);\n      ci--;\n    }\n\n    var leaf = isleaf(node, obj);\n    if (!leaf.leaf && leaf.childnode) return count + remove(leaf.childnode, obj, attr);\n    return count;\n  } // put an object to this node\n\n\n  function put(node, obj) {\n    if (!validate(obj)) return;\n\n    if (node.n.length == 0) {\n      node.c.push(obj); // subdivide\n\n      if (node.c.length > maxc) {\n        var w2 = node.w / 2;\n        var h2 = node.h / 2;\n        node.n.push(createnode(node.x, node.y, w2, h2), createnode(node.x + w2, node.y, w2, h2), createnode(node.x, node.y + h2, w2, h2), createnode(node.x + w2, node.y + h2, w2, h2));\n\n        for (var ci = 0; ci < node.c.length; ci++) put_to_nodes(node, node.c[ci]);\n\n        node.c = [];\n      }\n    } else put_to_nodes(node, obj);\n  } // iterate through all objects in this node matching given overlap\n  // function\n\n\n  function getter(overlapfun, node, obj, buf, strict, callbackOrArray) {\n    for (var li = 0; li < node.l.length; li++) if (!strict || overlapfun(obj, node.l[li], buf)) if (typeof callbackOrArray == 'object') callbackOrArray.push(node.l[li]);else if (!callbackOrArray(node.l[li])) return false;\n\n    for (var li = 0; li < node.c.length; li++) if (!strict || overlapfun(obj, node.c[li], buf)) if (typeof callbackOrArray == 'object') callbackOrArray.push(node.c[li]);else if (!callbackOrArray(node.c[li])) return false;\n\n    for (var ni = 0; ni < node.n.length; ni++) {\n      if (overlapfun(obj, node.n[ni], buf)) {\n        if (typeof callbackOrArray == 'object') callbackOrArray.concat(getter(overlapfun, node.n[ni], obj, buf, strict, callbackOrArray));else if (!getter(overlapfun, node.n[ni], obj, buf, strict, callbackOrArray)) return false;\n      }\n    }\n\n    return true;\n  } // iterate through all objects in this node matching the given rectangle\n\n\n  function get_rect(node, obj, buf, callbackOrArray) {\n    return getter(overlap_rect, node, obj, buf, true, callbackOrArray);\n  } // iterate through all objects in this node matching the given\n  // line (segment)\n\n\n  function get_line(node, obj, buf, callbackOrArray) {\n    return getter(overlap_line, node, obj, buf, false, callbackOrArray);\n  } // iterate through all objects in this node matching given\n  // geometry, either a rectangle or a line segment\n\n\n  function get(node, obj, buf, callbackOrArray) {\n    if ((typeof buf == 'function' || typeof buf == 'object') && typeof callbackOrArray == 'undefined') {\n      callbackOrArray = buf;\n      buf = 0;\n    }\n\n    if (typeof callbackOrArray == 'undefined') {\n      callbackOrArray = [];\n      buf = 0;\n    }\n\n    if (obj == null) get_rect(node, obj, buf, callbackOrArray);else if (typeof obj.x == 'number' && typeof obj.y == 'number' && !isNaN(obj.x) && !isNaN(obj.y)) {\n      if (typeof obj.dx == 'number' && typeof obj.dy == 'number' && !isNaN(obj.dx) && !isNaN(obj.dy)) get_line(node, obj, buf, callbackOrArray);else if (typeof obj.w == 'number' && typeof obj.h == 'number' && !isNaN(obj.w) && !isNaN(obj.h)) get_rect(node, obj, buf, callbackOrArray);\n    }\n    if (typeof callbackOrArray == 'object') return callbackOrArray;\n  } // return the object interface\n\n\n  return {\n    get: function (obj, buf, callbackOrArray) {\n      return get(root, obj, buf, callbackOrArray);\n    },\n    put: function (obj) {\n      put(root, obj);\n    },\n    update: function (obj, attr, updatedcoords) {\n      return update(root, obj, attr, updatedcoords);\n    },\n    remove: function (obj, attr) {\n      return remove(root, obj, attr);\n    },\n    clear: function () {\n      root = createnode(x, y, w, h);\n    },\n    stringify: function () {\n      var strobj = {\n        x: x,\n        y: y,\n        w: w,\n        h: h,\n        maxc: maxc,\n        leafratio: leafratio,\n        root: root\n      };\n\n      try {\n        return JSON.stringify(strobj);\n      } catch (err) {\n        // could not stringify\n        // probably due to objects included in qtree being non-stringifiable\n        return null;\n      }\n    },\n    parse: function (str) {\n      if (typeof str == 'string') str = JSON.parse(str);\n      x = str.x;\n      y = str.y;\n      w = str.w;\n      h = str.h;\n      maxc = str.maxc;\n      leafratio = str.leafratio;\n      root = str.root;\n    }\n  };\n} // for use within node.js\n\n\nif (true) module.exports = QuadTree;\n\n//# sourceURL=webpack:////Users/mu/node_modules/simple-quadtree/qtree.js?");

/***/ }),

/***/ "../../node_modules/tinyqueue/index.js":
/*!*************************************************!*\
  !*** /Users/mu/node_modules/tinyqueue/index.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return TinyQueue; });\nclass TinyQueue {\n  constructor(data = [], compare = defaultCompare) {\n    this.data = data;\n    this.length = this.data.length;\n    this.compare = compare;\n\n    if (this.length > 0) {\n      for (let i = (this.length >> 1) - 1; i >= 0; i--) this._down(i);\n    }\n  }\n\n  push(item) {\n    this.data.push(item);\n    this.length++;\n\n    this._up(this.length - 1);\n  }\n\n  pop() {\n    if (this.length === 0) return undefined;\n    const top = this.data[0];\n    const bottom = this.data.pop();\n    this.length--;\n\n    if (this.length > 0) {\n      this.data[0] = bottom;\n\n      this._down(0);\n    }\n\n    return top;\n  }\n\n  peek() {\n    return this.data[0];\n  }\n\n  _up(pos) {\n    const {\n      data,\n      compare\n    } = this;\n    const item = data[pos];\n\n    while (pos > 0) {\n      const parent = pos - 1 >> 1;\n      const current = data[parent];\n      if (compare(item, current) >= 0) break;\n      data[pos] = current;\n      pos = parent;\n    }\n\n    data[pos] = item;\n  }\n\n  _down(pos) {\n    const {\n      data,\n      compare\n    } = this;\n    const halfLength = this.length >> 1;\n    const item = data[pos];\n\n    while (pos < halfLength) {\n      let left = (pos << 1) + 1;\n      let best = data[left];\n      const right = left + 1;\n\n      if (right < this.length && compare(data[right], best) < 0) {\n        left = right;\n        best = data[right];\n      }\n\n      if (compare(best, item) >= 0) break;\n      data[pos] = best;\n      pos = left;\n    }\n\n    data[pos] = item;\n  }\n\n}\n\nfunction defaultCompare(a, b) {\n  return a < b ? -1 : a > b ? 1 : 0;\n}\n\n//# sourceURL=webpack:////Users/mu/node_modules/tinyqueue/index.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/index.js":
/*!*************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/index.js ***!
  \*************************************************************/
/*! exports provided: v1, v3, v4, v5, NIL, version, validate, stringify, parse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _v1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v1.js */ \"../../node_modules/uuid/dist/esm-browser/v1.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"v1\", function() { return _v1_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]; });\n\n/* harmony import */ var _v3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./v3.js */ \"../../node_modules/uuid/dist/esm-browser/v3.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"v3\", function() { return _v3_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]; });\n\n/* harmony import */ var _v4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./v4.js */ \"../../node_modules/uuid/dist/esm-browser/v4.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"v4\", function() { return _v4_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"]; });\n\n/* harmony import */ var _v5_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./v5.js */ \"../../node_modules/uuid/dist/esm-browser/v5.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"v5\", function() { return _v5_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"]; });\n\n/* harmony import */ var _nil_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./nil.js */ \"../../node_modules/uuid/dist/esm-browser/nil.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"NIL\", function() { return _nil_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]; });\n\n/* harmony import */ var _version_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./version.js */ \"../../node_modules/uuid/dist/esm-browser/version.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"version\", function() { return _version_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]; });\n\n/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./validate.js */ \"../../node_modules/uuid/dist/esm-browser/validate.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"validate\", function() { return _validate_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"]; });\n\n/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./stringify.js */ \"../../node_modules/uuid/dist/esm-browser/stringify.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"stringify\", function() { return _stringify_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"]; });\n\n/* harmony import */ var _parse_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./parse.js */ \"../../node_modules/uuid/dist/esm-browser/parse.js\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"parse\", function() { return _parse_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"]; });\n\n\n\n\n\n\n\n\n\n\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/index.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/md5.js":
/*!***********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/md5.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/*\n * Browser-compatible JavaScript MD5\n *\n * Modification of JavaScript MD5\n * https://github.com/blueimp/JavaScript-MD5\n *\n * Copyright 2011, Sebastian Tschan\n * https://blueimp.net\n *\n * Licensed under the MIT license:\n * https://opensource.org/licenses/MIT\n *\n * Based on\n * A JavaScript implementation of the RSA Data Security, Inc. MD5 Message\n * Digest Algorithm, as defined in RFC 1321.\n * Version 2.2 Copyright (C) Paul Johnston 1999 - 2009\n * Other contributors: Greg Holt, Andrew Kepert, Ydnar, Lostinet\n * Distributed under the BSD License\n * See http://pajhome.org.uk/crypt/md5 for more info.\n */\nfunction md5(bytes) {\n  if (typeof bytes === 'string') {\n    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape\n\n    bytes = new Uint8Array(msg.length);\n\n    for (var i = 0; i < msg.length; ++i) {\n      bytes[i] = msg.charCodeAt(i);\n    }\n  }\n\n  return md5ToHexEncodedArray(wordsToMd5(bytesToWords(bytes), bytes.length * 8));\n}\n/*\n * Convert an array of little-endian words to an array of bytes\n */\n\n\nfunction md5ToHexEncodedArray(input) {\n  var output = [];\n  var length32 = input.length * 32;\n  var hexTab = '0123456789abcdef';\n\n  for (var i = 0; i < length32; i += 8) {\n    var x = input[i >> 5] >>> i % 32 & 0xff;\n    var hex = parseInt(hexTab.charAt(x >>> 4 & 0x0f) + hexTab.charAt(x & 0x0f), 16);\n    output.push(hex);\n  }\n\n  return output;\n}\n/**\n * Calculate output length with padding and bit length\n */\n\n\nfunction getOutputLength(inputLength8) {\n  return (inputLength8 + 64 >>> 9 << 4) + 14 + 1;\n}\n/*\n * Calculate the MD5 of an array of little-endian words, and a bit length.\n */\n\n\nfunction wordsToMd5(x, len) {\n  /* append padding */\n  x[len >> 5] |= 0x80 << len % 32;\n  x[getOutputLength(len) - 1] = len;\n  var a = 1732584193;\n  var b = -271733879;\n  var c = -1732584194;\n  var d = 271733878;\n\n  for (var i = 0; i < x.length; i += 16) {\n    var olda = a;\n    var oldb = b;\n    var oldc = c;\n    var oldd = d;\n    a = md5ff(a, b, c, d, x[i], 7, -680876936);\n    d = md5ff(d, a, b, c, x[i + 1], 12, -389564586);\n    c = md5ff(c, d, a, b, x[i + 2], 17, 606105819);\n    b = md5ff(b, c, d, a, x[i + 3], 22, -1044525330);\n    a = md5ff(a, b, c, d, x[i + 4], 7, -176418897);\n    d = md5ff(d, a, b, c, x[i + 5], 12, 1200080426);\n    c = md5ff(c, d, a, b, x[i + 6], 17, -1473231341);\n    b = md5ff(b, c, d, a, x[i + 7], 22, -45705983);\n    a = md5ff(a, b, c, d, x[i + 8], 7, 1770035416);\n    d = md5ff(d, a, b, c, x[i + 9], 12, -1958414417);\n    c = md5ff(c, d, a, b, x[i + 10], 17, -42063);\n    b = md5ff(b, c, d, a, x[i + 11], 22, -1990404162);\n    a = md5ff(a, b, c, d, x[i + 12], 7, 1804603682);\n    d = md5ff(d, a, b, c, x[i + 13], 12, -40341101);\n    c = md5ff(c, d, a, b, x[i + 14], 17, -1502002290);\n    b = md5ff(b, c, d, a, x[i + 15], 22, 1236535329);\n    a = md5gg(a, b, c, d, x[i + 1], 5, -165796510);\n    d = md5gg(d, a, b, c, x[i + 6], 9, -1069501632);\n    c = md5gg(c, d, a, b, x[i + 11], 14, 643717713);\n    b = md5gg(b, c, d, a, x[i], 20, -373897302);\n    a = md5gg(a, b, c, d, x[i + 5], 5, -701558691);\n    d = md5gg(d, a, b, c, x[i + 10], 9, 38016083);\n    c = md5gg(c, d, a, b, x[i + 15], 14, -660478335);\n    b = md5gg(b, c, d, a, x[i + 4], 20, -405537848);\n    a = md5gg(a, b, c, d, x[i + 9], 5, 568446438);\n    d = md5gg(d, a, b, c, x[i + 14], 9, -1019803690);\n    c = md5gg(c, d, a, b, x[i + 3], 14, -187363961);\n    b = md5gg(b, c, d, a, x[i + 8], 20, 1163531501);\n    a = md5gg(a, b, c, d, x[i + 13], 5, -1444681467);\n    d = md5gg(d, a, b, c, x[i + 2], 9, -51403784);\n    c = md5gg(c, d, a, b, x[i + 7], 14, 1735328473);\n    b = md5gg(b, c, d, a, x[i + 12], 20, -1926607734);\n    a = md5hh(a, b, c, d, x[i + 5], 4, -378558);\n    d = md5hh(d, a, b, c, x[i + 8], 11, -2022574463);\n    c = md5hh(c, d, a, b, x[i + 11], 16, 1839030562);\n    b = md5hh(b, c, d, a, x[i + 14], 23, -35309556);\n    a = md5hh(a, b, c, d, x[i + 1], 4, -1530992060);\n    d = md5hh(d, a, b, c, x[i + 4], 11, 1272893353);\n    c = md5hh(c, d, a, b, x[i + 7], 16, -155497632);\n    b = md5hh(b, c, d, a, x[i + 10], 23, -1094730640);\n    a = md5hh(a, b, c, d, x[i + 13], 4, 681279174);\n    d = md5hh(d, a, b, c, x[i], 11, -358537222);\n    c = md5hh(c, d, a, b, x[i + 3], 16, -722521979);\n    b = md5hh(b, c, d, a, x[i + 6], 23, 76029189);\n    a = md5hh(a, b, c, d, x[i + 9], 4, -640364487);\n    d = md5hh(d, a, b, c, x[i + 12], 11, -421815835);\n    c = md5hh(c, d, a, b, x[i + 15], 16, 530742520);\n    b = md5hh(b, c, d, a, x[i + 2], 23, -995338651);\n    a = md5ii(a, b, c, d, x[i], 6, -198630844);\n    d = md5ii(d, a, b, c, x[i + 7], 10, 1126891415);\n    c = md5ii(c, d, a, b, x[i + 14], 15, -1416354905);\n    b = md5ii(b, c, d, a, x[i + 5], 21, -57434055);\n    a = md5ii(a, b, c, d, x[i + 12], 6, 1700485571);\n    d = md5ii(d, a, b, c, x[i + 3], 10, -1894986606);\n    c = md5ii(c, d, a, b, x[i + 10], 15, -1051523);\n    b = md5ii(b, c, d, a, x[i + 1], 21, -2054922799);\n    a = md5ii(a, b, c, d, x[i + 8], 6, 1873313359);\n    d = md5ii(d, a, b, c, x[i + 15], 10, -30611744);\n    c = md5ii(c, d, a, b, x[i + 6], 15, -1560198380);\n    b = md5ii(b, c, d, a, x[i + 13], 21, 1309151649);\n    a = md5ii(a, b, c, d, x[i + 4], 6, -145523070);\n    d = md5ii(d, a, b, c, x[i + 11], 10, -1120210379);\n    c = md5ii(c, d, a, b, x[i + 2], 15, 718787259);\n    b = md5ii(b, c, d, a, x[i + 9], 21, -343485551);\n    a = safeAdd(a, olda);\n    b = safeAdd(b, oldb);\n    c = safeAdd(c, oldc);\n    d = safeAdd(d, oldd);\n  }\n\n  return [a, b, c, d];\n}\n/*\n * Convert an array bytes to an array of little-endian words\n * Characters >255 have their high-byte silently ignored.\n */\n\n\nfunction bytesToWords(input) {\n  if (input.length === 0) {\n    return [];\n  }\n\n  var length8 = input.length * 8;\n  var output = new Uint32Array(getOutputLength(length8));\n\n  for (var i = 0; i < length8; i += 8) {\n    output[i >> 5] |= (input[i / 8] & 0xff) << i % 32;\n  }\n\n  return output;\n}\n/*\n * Add integers, wrapping at 2^32. This uses 16-bit operations internally\n * to work around bugs in some JS interpreters.\n */\n\n\nfunction safeAdd(x, y) {\n  var lsw = (x & 0xffff) + (y & 0xffff);\n  var msw = (x >> 16) + (y >> 16) + (lsw >> 16);\n  return msw << 16 | lsw & 0xffff;\n}\n/*\n * Bitwise rotate a 32-bit number to the left.\n */\n\n\nfunction bitRotateLeft(num, cnt) {\n  return num << cnt | num >>> 32 - cnt;\n}\n/*\n * These functions implement the four basic operations the algorithm uses.\n */\n\n\nfunction md5cmn(q, a, b, x, s, t) {\n  return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);\n}\n\nfunction md5ff(a, b, c, d, x, s, t) {\n  return md5cmn(b & c | ~b & d, a, b, x, s, t);\n}\n\nfunction md5gg(a, b, c, d, x, s, t) {\n  return md5cmn(b & d | c & ~d, a, b, x, s, t);\n}\n\nfunction md5hh(a, b, c, d, x, s, t) {\n  return md5cmn(b ^ c ^ d, a, b, x, s, t);\n}\n\nfunction md5ii(a, b, c, d, x, s, t) {\n  return md5cmn(c ^ (b | ~d), a, b, x, s, t);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (md5);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/md5.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/nil.js":
/*!***********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/nil.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = ('00000000-0000-0000-0000-000000000000');\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/nil.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/parse.js":
/*!*************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/parse.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ \"../../node_modules/uuid/dist/esm-browser/validate.js\");\n\n\nfunction parse(uuid) {\n  if (!Object(_validate_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(uuid)) {\n    throw TypeError('Invalid UUID');\n  }\n\n  var v;\n  var arr = new Uint8Array(16); // Parse ########-....-....-....-............\n\n  arr[0] = (v = parseInt(uuid.slice(0, 8), 16)) >>> 24;\n  arr[1] = v >>> 16 & 0xff;\n  arr[2] = v >>> 8 & 0xff;\n  arr[3] = v & 0xff; // Parse ........-####-....-....-............\n\n  arr[4] = (v = parseInt(uuid.slice(9, 13), 16)) >>> 8;\n  arr[5] = v & 0xff; // Parse ........-....-####-....-............\n\n  arr[6] = (v = parseInt(uuid.slice(14, 18), 16)) >>> 8;\n  arr[7] = v & 0xff; // Parse ........-....-....-####-............\n\n  arr[8] = (v = parseInt(uuid.slice(19, 23), 16)) >>> 8;\n  arr[9] = v & 0xff; // Parse ........-....-....-....-############\n  // (Use \"/\" to avoid 32-bit truncation when bit-shifting high-order bytes)\n\n  arr[10] = (v = parseInt(uuid.slice(24, 36), 16)) / 0x10000000000 & 0xff;\n  arr[11] = v / 0x100000000 & 0xff;\n  arr[12] = v >>> 24 & 0xff;\n  arr[13] = v >>> 16 & 0xff;\n  arr[14] = v >>> 8 & 0xff;\n  arr[15] = v & 0xff;\n  return arr;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (parse);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/parse.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/regex.js":
/*!*************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/regex.js ***!
  \*************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (/^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/regex.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/rng.js":
/*!***********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/rng.js ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return rng; });\n// Unique ID creation requires a high quality random # generator. In the browser we therefore\n// require the crypto API and do not support built-in fallback to lower quality random number\n// generators (like Math.random()).\nvar getRandomValues;\nvar rnds8 = new Uint8Array(16);\nfunction rng() {\n  // lazy load so that environments that need to polyfill have a chance to do so\n  if (!getRandomValues) {\n    // getRandomValues needs to be invoked in a context where \"this\" is a Crypto implementation. Also,\n    // find the complete implementation of crypto (msCrypto) on IE11.\n    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto) || typeof msCrypto !== 'undefined' && typeof msCrypto.getRandomValues === 'function' && msCrypto.getRandomValues.bind(msCrypto);\n\n    if (!getRandomValues) {\n      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');\n    }\n  }\n\n  return getRandomValues(rnds8);\n}\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/rng.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/sha1.js":
/*!************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/sha1.js ***!
  \************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n// Adapted from Chris Veness' SHA1 code at\n// http://www.movable-type.co.uk/scripts/sha1.html\nfunction f(s, x, y, z) {\n  switch (s) {\n    case 0:\n      return x & y ^ ~x & z;\n\n    case 1:\n      return x ^ y ^ z;\n\n    case 2:\n      return x & y ^ x & z ^ y & z;\n\n    case 3:\n      return x ^ y ^ z;\n  }\n}\n\nfunction ROTL(x, n) {\n  return x << n | x >>> 32 - n;\n}\n\nfunction sha1(bytes) {\n  var K = [0x5a827999, 0x6ed9eba1, 0x8f1bbcdc, 0xca62c1d6];\n  var H = [0x67452301, 0xefcdab89, 0x98badcfe, 0x10325476, 0xc3d2e1f0];\n\n  if (typeof bytes === 'string') {\n    var msg = unescape(encodeURIComponent(bytes)); // UTF8 escape\n\n    bytes = [];\n\n    for (var i = 0; i < msg.length; ++i) {\n      bytes.push(msg.charCodeAt(i));\n    }\n  } else if (!Array.isArray(bytes)) {\n    // Convert Array-like to Array\n    bytes = Array.prototype.slice.call(bytes);\n  }\n\n  bytes.push(0x80);\n  var l = bytes.length / 4 + 2;\n  var N = Math.ceil(l / 16);\n  var M = new Array(N);\n\n  for (var _i = 0; _i < N; ++_i) {\n    var arr = new Uint32Array(16);\n\n    for (var j = 0; j < 16; ++j) {\n      arr[j] = bytes[_i * 64 + j * 4] << 24 | bytes[_i * 64 + j * 4 + 1] << 16 | bytes[_i * 64 + j * 4 + 2] << 8 | bytes[_i * 64 + j * 4 + 3];\n    }\n\n    M[_i] = arr;\n  }\n\n  M[N - 1][14] = (bytes.length - 1) * 8 / Math.pow(2, 32);\n  M[N - 1][14] = Math.floor(M[N - 1][14]);\n  M[N - 1][15] = (bytes.length - 1) * 8 & 0xffffffff;\n\n  for (var _i2 = 0; _i2 < N; ++_i2) {\n    var W = new Uint32Array(80);\n\n    for (var t = 0; t < 16; ++t) {\n      W[t] = M[_i2][t];\n    }\n\n    for (var _t = 16; _t < 80; ++_t) {\n      W[_t] = ROTL(W[_t - 3] ^ W[_t - 8] ^ W[_t - 14] ^ W[_t - 16], 1);\n    }\n\n    var a = H[0];\n    var b = H[1];\n    var c = H[2];\n    var d = H[3];\n    var e = H[4];\n\n    for (var _t2 = 0; _t2 < 80; ++_t2) {\n      var s = Math.floor(_t2 / 20);\n      var T = ROTL(a, 5) + f(s, b, c, d) + e + K[s] + W[_t2] >>> 0;\n      e = d;\n      d = c;\n      c = ROTL(b, 30) >>> 0;\n      b = a;\n      a = T;\n    }\n\n    H[0] = H[0] + a >>> 0;\n    H[1] = H[1] + b >>> 0;\n    H[2] = H[2] + c >>> 0;\n    H[3] = H[3] + d >>> 0;\n    H[4] = H[4] + e >>> 0;\n  }\n\n  return [H[0] >> 24 & 0xff, H[0] >> 16 & 0xff, H[0] >> 8 & 0xff, H[0] & 0xff, H[1] >> 24 & 0xff, H[1] >> 16 & 0xff, H[1] >> 8 & 0xff, H[1] & 0xff, H[2] >> 24 & 0xff, H[2] >> 16 & 0xff, H[2] >> 8 & 0xff, H[2] & 0xff, H[3] >> 24 & 0xff, H[3] >> 16 & 0xff, H[3] >> 8 & 0xff, H[3] & 0xff, H[4] >> 24 & 0xff, H[4] >> 16 & 0xff, H[4] >> 8 & 0xff, H[4] & 0xff];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (sha1);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/sha1.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/stringify.js":
/*!*****************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/stringify.js ***!
  \*****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ \"../../node_modules/uuid/dist/esm-browser/validate.js\");\n\n/**\n * Convert array of 16 byte values to UUID string format of the form:\n * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX\n */\n\nvar byteToHex = [];\n\nfor (var i = 0; i < 256; ++i) {\n  byteToHex.push((i + 0x100).toString(16).substr(1));\n}\n\nfunction stringify(arr) {\n  var offset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0; // Note: Be careful editing this code!  It's been tuned for performance\n  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434\n\n  var uuid = (byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]]).toLowerCase(); // Consistency check for valid UUID.  If this throws, it's likely due to one\n  // of the following:\n  // - One or more input array values don't map to a hex octet (leading to\n  // \"undefined\" in the uuid)\n  // - Invalid input values for the RFC `version` or `variant` fields\n\n  if (!Object(_validate_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(uuid)) {\n    throw TypeError('Stringified UUID is invalid');\n  }\n\n  return uuid;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (stringify);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/stringify.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/v1.js":
/*!**********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/v1.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ \"../../node_modules/uuid/dist/esm-browser/rng.js\");\n/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringify.js */ \"../../node_modules/uuid/dist/esm-browser/stringify.js\");\n\n // **`v1()` - Generate time-based UUID**\n//\n// Inspired by https://github.com/LiosK/UUID.js\n// and http://docs.python.org/library/uuid.html\n\nvar _nodeId;\n\nvar _clockseq; // Previous uuid creation time\n\n\nvar _lastMSecs = 0;\nvar _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details\n\nfunction v1(options, buf, offset) {\n  var i = buf && offset || 0;\n  var b = buf || new Array(16);\n  options = options || {};\n  var node = options.node || _nodeId;\n  var clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not\n  // specified.  We do this lazily to minimize issues related to insufficient\n  // system entropy.  See #189\n\n  if (node == null || clockseq == null) {\n    var seedBytes = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])();\n\n    if (node == null) {\n      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)\n      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];\n    }\n\n    if (clockseq == null) {\n      // Per 4.2.2, randomize (14 bit) clockseq\n      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;\n    }\n  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,\n  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so\n  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'\n  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.\n\n\n  var msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock\n  // cycle to simulate higher resolution clock\n\n  var nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)\n\n  var dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression\n\n  if (dt < 0 && options.clockseq === undefined) {\n    clockseq = clockseq + 1 & 0x3fff;\n  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new\n  // time interval\n\n\n  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {\n    nsecs = 0;\n  } // Per 4.2.1.2 Throw error if too many uuids are requested\n\n\n  if (nsecs >= 10000) {\n    throw new Error(\"uuid.v1(): Can't create more than 10M uuids/sec\");\n  }\n\n  _lastMSecs = msecs;\n  _lastNSecs = nsecs;\n  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch\n\n  msecs += 12219292800000; // `time_low`\n\n  var tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;\n  b[i++] = tl >>> 24 & 0xff;\n  b[i++] = tl >>> 16 & 0xff;\n  b[i++] = tl >>> 8 & 0xff;\n  b[i++] = tl & 0xff; // `time_mid`\n\n  var tmh = msecs / 0x100000000 * 10000 & 0xfffffff;\n  b[i++] = tmh >>> 8 & 0xff;\n  b[i++] = tmh & 0xff; // `time_high_and_version`\n\n  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version\n\n  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)\n\n  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`\n\n  b[i++] = clockseq & 0xff; // `node`\n\n  for (var n = 0; n < 6; ++n) {\n    b[i + n] = node[n];\n  }\n\n  return buf || Object(_stringify_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(b);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (v1);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/v1.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/v3.js":
/*!**********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/v3.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ \"../../node_modules/uuid/dist/esm-browser/v35.js\");\n/* harmony import */ var _md5_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./md5.js */ \"../../node_modules/uuid/dist/esm-browser/md5.js\");\n\n\nvar v3 = Object(_v35_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])('v3', 0x30, _md5_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n/* harmony default export */ __webpack_exports__[\"default\"] = (v3);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/v3.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/v35.js":
/*!***********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/v35.js ***!
  \***********************************************************/
/*! exports provided: DNS, URL, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"DNS\", function() { return DNS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"URL\", function() { return URL; });\n/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./stringify.js */ \"../../node_modules/uuid/dist/esm-browser/stringify.js\");\n/* harmony import */ var _parse_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./parse.js */ \"../../node_modules/uuid/dist/esm-browser/parse.js\");\n\n\n\nfunction stringToBytes(str) {\n  str = unescape(encodeURIComponent(str)); // UTF8 escape\n\n  var bytes = [];\n\n  for (var i = 0; i < str.length; ++i) {\n    bytes.push(str.charCodeAt(i));\n  }\n\n  return bytes;\n}\n\nvar DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';\nvar URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';\n/* harmony default export */ __webpack_exports__[\"default\"] = (function (name, version, hashfunc) {\n  function generateUUID(value, namespace, buf, offset) {\n    if (typeof value === 'string') {\n      value = stringToBytes(value);\n    }\n\n    if (typeof namespace === 'string') {\n      namespace = Object(_parse_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(namespace);\n    }\n\n    if (namespace.length !== 16) {\n      throw TypeError('Namespace must be array-like (16 iterable integer values, 0-255)');\n    } // Compute hash of namespace and value, Per 4.3\n    // Future: Use spread syntax when supported on all platforms, e.g. `bytes =\n    // hashfunc([...namespace, ... value])`\n\n\n    var bytes = new Uint8Array(16 + value.length);\n    bytes.set(namespace);\n    bytes.set(value, namespace.length);\n    bytes = hashfunc(bytes);\n    bytes[6] = bytes[6] & 0x0f | version;\n    bytes[8] = bytes[8] & 0x3f | 0x80;\n\n    if (buf) {\n      offset = offset || 0;\n\n      for (var i = 0; i < 16; ++i) {\n        buf[offset + i] = bytes[i];\n      }\n\n      return buf;\n    }\n\n    return Object(_stringify_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(bytes);\n  } // Function#name is not settable on some platforms (#270)\n\n\n  try {\n    generateUUID.name = name; // eslint-disable-next-line no-empty\n  } catch (err) {} // For CommonJS default export support\n\n\n  generateUUID.DNS = DNS;\n  generateUUID.URL = URL;\n  return generateUUID;\n});\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/v35.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/v4.js":
/*!**********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/v4.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ \"../../node_modules/uuid/dist/esm-browser/rng.js\");\n/* harmony import */ var _stringify_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stringify.js */ \"../../node_modules/uuid/dist/esm-browser/stringify.js\");\n\n\n\nfunction v4(options, buf, offset) {\n  options = options || {};\n  var rnds = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`\n\n  rnds[6] = rnds[6] & 0x0f | 0x40;\n  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided\n\n  if (buf) {\n    offset = offset || 0;\n\n    for (var i = 0; i < 16; ++i) {\n      buf[offset + i] = rnds[i];\n    }\n\n    return buf;\n  }\n\n  return Object(_stringify_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(rnds);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (v4);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/v4.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/v5.js":
/*!**********************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/v5.js ***!
  \**********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ \"../../node_modules/uuid/dist/esm-browser/v35.js\");\n/* harmony import */ var _sha1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sha1.js */ \"../../node_modules/uuid/dist/esm-browser/sha1.js\");\n\n\nvar v5 = Object(_v35_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])('v5', 0x50, _sha1_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]);\n/* harmony default export */ __webpack_exports__[\"default\"] = (v5);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/v5.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/validate.js":
/*!****************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/validate.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _regex_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./regex.js */ \"../../node_modules/uuid/dist/esm-browser/regex.js\");\n\n\nfunction validate(uuid) {\n  return typeof uuid === 'string' && _regex_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].test(uuid);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (validate);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/validate.js?");

/***/ }),

/***/ "../../node_modules/uuid/dist/esm-browser/version.js":
/*!***************************************************************!*\
  !*** /Users/mu/node_modules/uuid/dist/esm-browser/version.js ***!
  \***************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _validate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./validate.js */ \"../../node_modules/uuid/dist/esm-browser/validate.js\");\n\n\nfunction version(uuid) {\n  if (!Object(_validate_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(uuid)) {\n    throw TypeError('Invalid UUID');\n  }\n\n  return parseInt(uuid.substr(14, 1), 16);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (version);\n\n//# sourceURL=webpack:////Users/mu/node_modules/uuid/dist/esm-browser/version.js?");

/***/ }),

/***/ "./pugins/use.js":
/*!***********************!*\
  !*** ./pugins/use.js ***!
  \***********************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var nav2d__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! nav2d */ \"../../node_modules/nav2d/src/nav2d.js\");\n\nwindow.NavMesh = nav2d__WEBPACK_IMPORTED_MODULE_0__[\"NavMesh\"];\nvar navmesh = new nav2d__WEBPACK_IMPORTED_MODULE_0__[\"NavMesh\"]([[[0, 0], [0, 12], [12, 0]], [[12, 8], [12, 4], [16, 6]], [[12, 0], [6, 6], [12, 6]], [[100, 100], [110, 100], [100, 110], [95, 107], [105, 102]]]);\nvar path = navmesh.findPath([1, 1], [14, 6]);\nconsole.log(path);\n\n//# sourceURL=webpack:///./pugins/use.js?");

/***/ })

/******/ });